﻿using UnityEngine;
using System.Collections;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.Collections.Generic;

namespace quicksdk
{
    // QuickSDKListener
    public abstract class QuickSDKListener : MonoBehaviour
    {
        //callback
		public abstract void onInitSuccess();

		public abstract void onInitFailed(ErrorMsg message);

        public abstract void onLoginSuccess(UserInfo userInfo);

		public abstract void onLoginFailed(ErrorMsg errMsg);

        public abstract void onLogoutSuccess();

        public abstract void onPaySuccess(PayResult payResult);

        public abstract void onPayFailed(PayResult payResult);

        public abstract void onPayCancel(PayResult payResult);

        public abstract void onSubsSkuCallback(string skuId, string qkOrderId);

        public virtual void onShareSuccess(){
            Debug.Log("onShareSuccess default");
        }

        public virtual void onShareCancel(){
            Debug.Log("onShareCancel default");
        }

        public virtual void onShareFailed(string msg){
            Debug.Log("onShareFailed default");
        }

        public virtual void onQueryGoogleSkuResult(List<GoogleSku> skus){
            Debug.Log("onQueryGoogleSkuResult default");
        }

        public virtual void onBindUnbindUserFailed(BindUserInfo bindUserInfo){
            Debug.Log("onBindUnbindUserFailed");
        }
        public virtual void onBindUnbindUserSuccess(BindUserInfo bindUserInfo){
            Debug.Log("onBindUnbindUserSuccess");
        }

        public virtual void onLoginTraceEvent(string name, string msg){
            Debug.Log("onLoginTraceEvent "+name);
        }

        public virtual void onCustomServiceMsgBack(string msgContent){
            Debug.Log("onCustomServiceMsgBack "+msgContent);
        }

        public virtual void onConversionDataSuccess(Dictionary<string, string> dataMap){
            Debug.Log("onConversionDataSuccess");
        }

        public virtual void onConversionDataFail(string s){
            Debug.Log("onConversionDataFail "+s);
        }

        public virtual void onAppOpenAttribution(Dictionary<string, string> dataMap){
            Debug.Log("onAppOpenAttribution ");
        }

        public virtual void onAttributionFailure(string s){
            Debug.Log("onAttributionFailure "+s);
        }

        public virtual void oNOpenReviewFinish(){
        }

        public virtual void onGetAdjustIdResult(string adid){
            Debug.Log("onGetAdjustIdResult " + adid);
        }

        //callback end

		public void onInitSuccess(string msg)
		{
			onInitSuccess();
		}

		public void onInitFailed(string msg)
		{
			var data = SimpleJSON.JSONNode.Parse(msg);
			ErrorMsg errMsg = new ErrorMsg();
			errMsg.errMsg =  data["msg"].Value;
			onInitFailed(errMsg);
		}

        public void onLoginSuccess(string msg)
        {
            var data = SimpleJSON.JSONNode.Parse(msg);
            UserInfo userInfo = new UserInfo();
            userInfo.uid = data["userId"].Value;
            userInfo.token = data["userToken"].Value;
            userInfo.userName = data["userName"].Value;
            userInfo.openType = data["openType"].Value;
            userInfo.isGuest = data["isGuest"].AsBool;
            userInfo.errMsg = data["msg"].Value;

            onLoginSuccess(userInfo);
        }

        public void onLoginFailed(string msg)
        {
            var data = SimpleJSON.JSONNode.Parse(msg);
			ErrorMsg errMsg = new ErrorMsg();
			errMsg.errMsg = data["msg"].Value;
            errMsg.code = int.Parse(data["stateCode"].Value);

			onLoginFailed(errMsg);
        }

        public void onBindFailed(string bindUserInfoStr){
            Debug.Log("onBindFailed "+bindUserInfoStr);
            var bindUserInfo = Newtonsoft.Json.JsonConvert.DeserializeObject<BindUserInfo>(bindUserInfoStr);
            onBindUnbindUserFailed(bindUserInfo);
        }

        public void onBindSuccess(string bindUserInfoStr){
            Debug.Log("onBindSuccess "+bindUserInfoStr);
            var bindUserInfo = Newtonsoft.Json.JsonConvert.DeserializeObject<BindUserInfo>(bindUserInfoStr);
            onBindUnbindUserSuccess(bindUserInfo);
        }

        public void onLogoutSuccess(string msg)
        {
            onLogoutSuccess();
        }



        public void onPaySuccess(string msg)
        {
            var data = SimpleJSON.JSONNode.Parse(msg);
            PayResult result = new PayResult();

            result.orderId = data["orderId"].Value;
            result.extraParam = data["extraParam"].Value;

            onPaySuccess(result);
        }

        public void onSubsSkuCallback(string msg)
        {
            var data = SimpleJSON.JSONNode.Parse(msg);
            onSubsSkuCallback(data["productId"].Value,data["orderId"].Value);
        }

        public void onPayFailed(string msg)
        {
            var data = SimpleJSON.JSONNode.Parse(msg);
            PayResult result = new PayResult();

            result.orderId = data["orderId"].Value;
            result.extraParam = data["extraParam"].Value;

            onPayFailed(result);
        }

        public void onPayCancel(string msg)
        {
            var data = SimpleJSON.JSONNode.Parse(msg);
            PayResult result = new PayResult();

            result.orderId = data["orderId"].Value;
            result.extraParam = data["extraParam"].Value;

            onPayCancel(result);
        }

        public void onQueryGoogleSkuResult(string skuJson)
		{
            if(string.Equals("",skuJson))
            {
                onQueryGoogleSkuResult(new List<GoogleSku>());
                return;
            }

            var skuDetails = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(skuJson);
            var result = new List<GoogleSku>();
            foreach(string skuStr in skuDetails){
                var sku = Newtonsoft.Json.JsonConvert.DeserializeObject<GoogleSku>(skuStr);
                result.Add(sku);
            }
            Debug.Log("onQueryGoogleSkuResult Count " + result.Count);
			onQueryGoogleSkuResult(result);
		}

        public void callLoginTraceEventToGame(string jsonString)
        {
            Debug.Log("callLoginTraceEventToGame " + jsonString);
            JObject jsonObject = JObject.Parse(jsonString);
            onLoginTraceEvent((string)jsonObject["name"], (string)jsonObject["msg"]);
        }

        public virtual void onConversionDataSuccess(string jsonString){
            Debug.Log("onConversionDataSuccess " + jsonString);
            Dictionary<string, string> dataMap = JsonConvert.DeserializeObject<Dictionary<string, string>>(jsonString);
            onConversionDataSuccess(dataMap);
        }

        public virtual void onAppOpenAttribution(string jsonString){
            Debug.Log("onAppOpenAttribution " + jsonString);
            Dictionary<string, string> dataMap = JsonConvert.DeserializeObject<Dictionary<string, string>>(jsonString);
            onAppOpenAttribution(dataMap);
        }

        public void oNOpenReviewFinish(string msg){
            Debug.Log("oNOpenReviewFinish");
            oNOpenReviewFinish();
        }
    }
}
